package thinkbot;

import shooting.WeaponStats;
import shooting.Predictor;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import intelligence.Intelligence;
import navigation.ThinkNavigation;
import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.HearNoise;
import cz.cuni.pogamut.MessageObjects.HearPickup;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.exceptions.PogamutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import shooting.AddWeaponMode;

/**
 *  NOTE: Class with agent must be marked also in manifest.mf, otherwise IDE don't know, which file it should run.
 */
public class ThinkBot extends Agent implements RcvMsgListener {
    // possible actions
    public final int ATTACK = 0,  RETREAT = 1, HIDE = 2, COLLECT = 3,  GETITEM = 4;
    public final int TRACE_LEFT = 1, TRACE_RIGHT = 2, TRACE_FORWARD = 3, TRACE_BACK = 4;
    public int currentAction = -1;
    // global time counter
    private int time = 0;
    // aging counter used for chasing
    private int lastSeen = 0;
    // variables used for stuck detecion
    private Triple lastLoc1 = new Triple(-10000000, 0, 0);
    private Triple lastLoc2 = new Triple( 10000000, 0, 0);
    private boolean wasStuck = true; //whether the last action caused bot to get stuck
    // battle strafing
    private Triple lastStrafeLoc = null;
    private int lastStrafeTime = 0;
    // noise
    private Triple lastHeardNoiseRot = null;
    // higher level goals
    private NavPoint higherLevelGoal1 = null;
    private NavPoint higherLevelGoal2 = null;
    
    Predictor predictor = new Predictor();
    Intelligence intelligence = new Intelligence(this);
    private ThinkNavigation navigation;
    
    public ThinkNavigation getNavigation() {
        return this.navigation;
    }
    
    public Triple getLastHeardNoiseRotation() {
        return this.lastHeardNoiseRot;        
    }

    public boolean isStuck() {
        return Triple.distanceInSpace(lastLoc1, lastLoc2) < 30;
    }
    
    public boolean gotStuck() {
        return !wasStuck && isStuck();
    }
    
    public synchronized void setHigherLevelGoals(NavPoint nav1, NavPoint nav2) {
        this.higherLevelGoal1 = nav1;
        this.higherLevelGoal2 = nav2;
    }
    
    protected void followIntelligence() {
        if (higherLevelGoal1 != null && higherLevelGoal2 != null) {
            body.moveAlongNavPoints(1.0, higherLevelGoal1, higherLevelGoal2);
        } else if (higherLevelGoal1 != null) {
            body.runToNavPoint(higherLevelGoal1);
        } else {
            doCrazyJumps();
        }
    }
    
    protected int getCurrentTime() {
        return time;
    }
    
    protected Item getSeeNearestItem() {
        double minDistance = Double.MAX_VALUE, dist;
        Item nearest = null;
        Triple agentLoc = memory.getAgentLocation();
        for (Item e: memory.getSeeItems()) {
            if ((e.location.z - agentLoc.z) > 200) continue;
            dist = Triple.distanceInPlane(e.location, agentLoc);
            if (dist < minDistance) {
                minDistance = dist;
                nearest = e;
            }
        }
        return nearest;
    }
    
    protected Triple getStrafeLocation(Triple enemyLoc, AddWeapon weapon) {
        WeaponStats ws = WeaponStats.getWeaponStats(weapon.getWeaponType());
        Triple direction = Triple.subtract(enemyLoc, memory.getAgentLocation()).normalize();
        if (lastStrafeLoc == null || Triple.distanceInSpace(enemyLoc, memory.getAgentLocation()) < 150
                || lastStrafeTime < getCurrentTime() - 10) {
            Triple strafeLoc = new Triple();
            if (Triple.distanceInSpace(enemyLoc, memory.getAgentLocation()) > ws.getFirstOptimalDistance()) {
                if (random.nextInt(2) == 0) {
                    strafeLoc.x = memory.getAgentLocation().x + direction.x*100 - direction.y*800;
                    strafeLoc.y = memory.getAgentLocation().y + direction.y*100 + direction.x*800;
                    strafeLoc.z = memory.getAgentLocation().z;
                } else {
                    strafeLoc.x = memory.getAgentLocation().x + direction.x*100 + direction.y*800;
                    strafeLoc.y = memory.getAgentLocation().y + direction.y*100 - direction.x*800;
                    strafeLoc.z = memory.getAgentLocation().z;
                }
            } else {
                if (random.nextInt(2) == 0) {
                    strafeLoc.x = memory.getAgentLocation().x - direction.x*100 - direction.y*800;
                    strafeLoc.y = memory.getAgentLocation().y - direction.y*100 + direction.x*800;
                    strafeLoc.z = memory.getAgentLocation().z;
                } else {
                    strafeLoc.x = memory.getAgentLocation().x - direction.x*100 + direction.y*800;
                    strafeLoc.y = memory.getAgentLocation().y - direction.y*100 - direction.x*800;
                    strafeLoc.z = memory.getAgentLocation().z;
                }
            }
            lastStrafeLoc = strafeLoc;
            lastStrafeTime = getCurrentTime();
            return strafeLoc;
        } else {
            return lastStrafeLoc;
        }
    }

    protected void modeAttack() {
        if (!memory.getSeeAnyEnemy()) {
            //we have lost him - chase!
            gameMap.safeRunToLocation(predictor.getLastPosition());
            //try to shoot behind corner
            if (memory.hasWeaponOfType(ItemType.FLAK_CANNON)) {
                if (memory.getCurrentWeapon().getWeaponType() != ItemType.FLAK_CANNON) {
                    body.changeWeapon(memory.getWeapon(ItemType.FLAK_CANNON));
                }
                if (memory.getAgentAmmo() > 0) {
                    body.shoot(predictor.getLastPosition());
                } else {
                    body.stopShoot();
                }
            } else if (memory.hasWeaponOfType(ItemType.ASSAULT_RIFLE)) {
                if (memory.getCurrentWeapon().getWeaponType() != ItemType.ASSAULT_RIFLE) {
                    body.changeWeapon(memory.getWeapon(ItemType.ASSAULT_RIFLE));
                }
                if (memory.getAgentAlternativeAmmo() > 0) {
                    body.shootAlternate(predictor.getLastPosition());
                } else {
                    body.stopShoot();
                }
            } else {
                body.stopShoot();
            }
        } else {
            Player p = memory.getSeeEnemy();
            AddWeaponMode selectedWeapon = WeaponStats.getBestWeapon(
                    memory.getAgentLocation(), predictor.getLastPosition(), memory.getAllWeapons(), log);
            boolean alternative = false;
            Triple strafeLoc = getStrafeLocation(p.location, memory.getCurrentWeapon());
            Triple shootLocation = null;
            if (selectedWeapon.weapon != null) {
                if (selectedWeapon.weapon.getWeaponType() !=
                        memory.getCurrentWeapon().getWeaponType()) {
                    body.changeWeapon(selectedWeapon.weapon);
                }
                shootLocation = predictor.getFuturePosition(
                        memory.getAgentLocation(),
                        selectedWeapon.weapon.getWeaponType(), alternative);
                if (shootLocation != null && selectedWeapon.weapon.getWeaponType() == ItemType.ROCKET_LAUNCHER) {
                    //we want to shoot under legs
                    shootLocation.z -= 30;
                }
            }
            log.info("Strafe" + strafeLoc.toString());
            if (shootLocation != null) {
                log.info("Shoot" + shootLocation.toString());
                body.strafeToLocation(strafeLoc, shootLocation);
                body.shoot(shootLocation);
            } else {
                log.info("Shoot to player" + p.location.toString());
                body.strafeToLocation(strafeLoc, p.location);
                body.shoot(p.location);
            }
        }
    }

    protected void modeGetItem(Item item) {
        gameMap.safeRunToLocation(item.location);
        if (this.gotStuck()) {
            navigation.setNavPointUnreachable(item.navPoint);
        }
    }

    // run to location specified by intelligence, but perform jinks
    protected void modeRetreat() {
        if (higherLevelGoal1 == null) {  
            doCrazyJumps();
        } else {
            if (this.gotStuck()) {
                synchronized (intelligence) {
                    RetreatThought t = (RetreatThought)intelligence.getCurrentThought();
                    if (t != null) {
                        t.setGoalUnreachable();
                    }
                }
            }
            /*body.turnToLocation(higherLevelGoal1.location);
            Triple direction = Triple.rotateYawPitchRoll(
                    Triple.subtract(higherLevelGoal1.location, memory.getAgentLocation()),
                    (random.nextDouble()-0.5)*Math.PI, 0, 0);
            if (getCurrentTime()%5 == 0) {
                body.jump();
                body.dodge(direction);
            }*/
            followIntelligence();                  
        }
    }

    public void resetStuck() {
        wasStuck = true;
    }

    private void actionChange(int action) {
        if (currentAction != action) {
            switch (action) {
                case ATTACK: log.info("Attacking"); break;
                case COLLECT: log.info("Collection"); break;
                case GETITEM: log.info("I see item"); break;
                case HIDE: log.info("Going to hide somewhere"); break;
                case RETREAT: log.info("Retreating..."); break;
            }
            currentAction = action;
            wasStuck = true;
        }
    }

    private void doCrazyJumps() {
        // dodge has a bug - bot starts flying when dodging too often
        if (getCurrentTime()%5 != 0) return;
        Triple direction = new Triple(1- 2*random.nextDouble(), 1 - 2*random.nextDouble(), 0);
        body.jump();
        body.dodge(direction);
    }
    
    class DecisionPair {

        public int action;
        public int ambition;

        public DecisionPair(int ac, int am) {
            action = ac;
            ambition = am;
        }
    }
        
    @Override
    protected void doLogic() {
        ArrayList<DecisionPair> want = new ArrayList();
        want.add(new DecisionPair(ATTACK, (memory.getSeeAnyEnemy() ? 100 : lastSeen) - 100));
        // retreat from battle to get ammo/health - go for higher level goal, but make jinks
        want.add(new DecisionPair(RETREAT, 180 - 2*memory.getHealth().getFlag().intValue()
                + (memory.hasAnyLoadedWeapon()?0:100)));
        // hide behind the corner to shoot enemy to his back when passing by
        want.add(new DecisionPair(HIDE, memory.getHearNoise() ? 50 : 0));
        // just leave it for higher level wandering
        want.add(new DecisionPair(COLLECT, 10));
        // if I see something near, get it!
        Item item = getSeeNearestItem();
        if (item != null) {
            want.add(new DecisionPair(GETITEM, (int) (30000 / Triple.distanceInSpace(
                    memory.getAgentLocation(), item.location))));
        }
        // we are sorting, because in possible future we may want to fetch more
        // actions at one moment
        Collections.sort(want, new Comparator() {

            @Override
            public int compare(Object o1, Object o2) {
                return ((DecisionPair) o2).ambition - ((DecisionPair) o1).ambition;
            }
        });
        if (memory.getSeeEnemy() != null) {
            predictor.addPosition(memory.getSeeEnemy().location);
            lastSeen = 100;
        }
        actionChange(want.get(0).action);
        switch (want.get(0).action) {
            case ATTACK:
                modeAttack();
                break;
            case RETREAT:
                intelligence.runThought(RetreatThought.class);
                modeRetreat();
                break;
            case GETITEM:
                modeGetItem(item);
                break;
            case HIDE:
                //intelligence.goHide();
                //followIntelligence();
                break;
            case COLLECT:
            default:
                //intelligence.goCollect();
                //followIntelligence();
                break;
                
        }
        // every 4 turns update info about location - stuck detection
        if (getCurrentTime()%20 == 0) {
            if (!isStuck()) {
                wasStuck = false;
            }
            lastLoc2 = lastLoc1;
            lastLoc1 = memory.getAgentLocation();
        }
        // decrease chasing coeficient
        lastSeen -= 3;
        // global time counter;
        ++time;
    }

    protected void prePrepareAgent() throws PogamutException {
        
    }

    protected void postPrepareAgent() throws PogamutException {
        body.initializer.setBotSkillLevel(3);
        body.removeAllRaysFromAutoTrace();
        body.addRayToAutoTrace(TRACE_LEFT, new Triple(0, -1, 0), new Double(100), true, false);
        body.addRayToAutoTrace(TRACE_RIGHT, new Triple(0, 1, 0), new Double(100), true, false);
        body.addRayToAutoTrace(TRACE_FORWARD, new Triple(1, 0, 0), new Double(100), true, false);
        body.addRayToAutoTrace(TRACE_BACK, new Triple(-1, 0, 0), new Double(100), true, false);
        body.addRcvMsgListener(this);
        navigation = new ThinkNavigation(this);
    }

    public void receiveMessage(RcvMsgEvent e) {
        switch (e.getMessage().getType()) {
            case HEAR_NOISE:
                this.lastHeardNoiseRot = ((HearNoise)e.getMessage()).rotation;
                break;
            case HEAR_PICKUP:
                this.lastHeardNoiseRot = ((HearPickup)e.getMessage()).rotation;
                break;
            case BOT_KILLED:
                intelligence.clear();
                break;
            case INCOMMING_PROJECTILE:
                //prevent jumping into the wall
                Triple rot = memory.getAgentRotation().normalize();
                Triple loc = memory.getAgentLocation();
                Triple left = new Triple(-rot.y*200, rot.x*200, rot.z);
                Triple right = new Triple(rot.y*200, -rot.x*200, rot.z);
                body.jump();
                if (random.nextInt(2) == 0) {
                    if (!this.memory.getAutoTraceByID(TRACE_LEFT).result) {
                        body.dodge(new Triple(0, -1, 0));
                    } else if (!this.memory.getAutoTraceByID(TRACE_RIGHT).result) {
                        body.dodge(new Triple(0, 1, 0));
                    }
                } else {
                    if (!this.memory.getAutoTraceByID(TRACE_RIGHT).result) {
                        body.dodge(new Triple(0, 1, 0));
                    } else if (!this.memory.getAutoTraceByID(TRACE_LEFT).result) {
                        body.dodge(new Triple(0, -1, 0));
                    }
                }
                break;
        }
    }    
    
    protected void shutdownAgent() throws PogamutException {
        navigation.killUpdator();
        intelligence.clear();
    }
    
    public static void main(String[] args) {
        /*
        DON'T DELETE THIS METHOD, IF YOU DELETE IT NETBEANS WON'T LET YOU RUN THIS 
        BOT. HOWEVER THIS METHOD IS NEVER EXECUTED, THE BOT IS LAUNCHED INSIDE THE 
        NETBEANS BY A CUSTOM ANT TASK (see build.xml).
         */
    }
}
